	% Example 5.11
	%           Bandpass filter for DECT handset 	
	% 	Author: 		Lars Wanhammar 2007-09-13
	
	clear all
	close all
	clc
	fs = 32000;	wsT1 = 9*2*pi/fs;	wcT1 = 300*2*pi/fs;
	wcT2 = 3000*2*pi/fs;	wsT2 = 4000*2*pi/fs;
	Amax = 0.15; Amin = 36.5;
	deltac = (10^(Amax/20)-1)/(10^(Amax/20)+1);
	deltas = (1+deltac)*(10^(-Amin/20));
	d = [deltas deltac deltas];
	wTedges = [wsT1 wcT1 wcT2 wsT2];
	[Norder, Be, D, W] = L_PHASE_BP_FIR_ORDER(wTedges, d);
	Norder = Norder-23	
	[h, Err] = REMEZ_FIR(Norder, Be, D, W, 'm');	
	wT = linspace(0, pi, 1000);  	H  = freqz(h,[1],wT);
	subplot(2,1,1)
	PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')	
	% Determine order for highpass case
	[N_HP, Be, D, W] = L_PHASE_HP_FIR_ORDER(wTedges(1:2), d(1:2));
	N_HP = 182
	% Determine order for lowpass case
	[N_LP, Be, D, W] = L_PHASE_LP_FIR_ORDER(wTedges(3:4), d(2:3));
	N_LP 	
	% Make N_LP  N_HP by reducing the stopband edge
	wTedges(4) = wsT2*0.835;
	[N_LP, Be, D, W] = L_PHASE_LP_FIR_ORDER(wTedges(3:4), d(2:3));
	N_LP = 182		 	
	[Norder, Be, D, W] = L_PHASE_BP_FIR_ORDER(wTedges, d);
	Norder = 182 
	[h, Err] = REMEZ_FIR(Norder, Be, D, W, 'm');		
	H = freqz(h,[1],wT);
	subplot(2,1,2)
	PLOT_MAG_Z_dB(wT, H, pi, 50, 'H')
